---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-Login Page.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **C-24**: エラーメッセージの具体的な文言 - APEX標準メッセージのため直接確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_09999.sql` (行1-218)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (行14)
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` (行10-11, 34, 69-71, 121)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行32)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは9999である | E-01 (行15) | ○ |
| C-02 | Page Aliasは'LOGIN'である | E-01 (行17) | ○ |
| C-03 | Step Titleは'QUASTO - Log In'である | E-01 (行18) | ○ |
| C-04 | ページは公開ページ（p_page_is_public_y_n=>'Y'） | E-01 (行24) | ○ |
| C-05 | Protection Levelは'C'である | E-01 (行25) | ○ |
| C-06 | P9999_USERNAMEはText Fieldである | E-01 (行62) | ○ |
| C-07 | P9999_USERNAMEのplaceholderは'Username' | E-01 (行61) | ○ |
| C-08 | P9999_USERNAMEのアイコンは'fa-user' | E-01 (行67) | ○ |
| C-09 | P9999_USERNAMEの最大長は100 | E-01 (行64) | ○ |
| C-10 | P9999_PASSWORDはNATIVE_PASSWORDである | E-01 (行83) | ○ |
| C-11 | P9999_PASSWORDのplaceholderは'Password' | E-01 (行82) | ○ |
| C-12 | P9999_PASSWORDのアイコンは'fa-key' | E-01 (行88) | ○ |
| C-13 | P9999_REMEMBERはNATIVE_SINGLE_CHECKBOX | E-01 (行99) | ○ |
| C-14 | P9999_REMEMBERの表示条件はpersistent_cookies_enabled | E-01 (行101-103) | ○ |
| C-15 | Sign Inボタンはホットボタン（p_button_is_hot=>'Y'） | E-01 (行48) | ○ |
| C-16 | Sign Inボタンのラベルは'Sign In' | E-01 (行49) | ○ |
| C-17 | Set Username CookieプロセスはSEND_LOGIN_USERNAME_COOKIE呼び出し | E-01 (行117) | ○ |
| C-18 | Set Username Cookieでユーザー名は小文字変換 | E-01 (行132) | ○ |
| C-19 | LoginプロセスはAPEX_AUTHENTICATION.LOGIN呼び出し | E-01 (行153-154) | ○ |
| C-20 | Loginプロセスにp_username, p_passwordパラメータが渡される | E-01 (行162-168, 170-180) | ○ |
| C-21 | Clear Page(s) CacheプロセスはCLEAR_CACHE_CURRENT_PAGE | E-01 (行199) | ○ |
| C-22 | Get Username CookieプロセスはBEFORE_HEADERで実行 | E-01 (行206) | ○ |
| C-23 | Get Username CookieでP9999_REMEMBERが条件セットされる | E-01 (行210-211) | ○ |
| C-24 | 認証失敗時のエラーメッセージ内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24**: 認証失敗時のエラーメッセージの具体的文言
  - APEX_AUTHENTICATION.LOGINはOracle APEX標準パッケージであり、エラーメッセージはAPEX内部で定義されている
  - 設計書ではAPEX標準の一般的なメッセージを記載したが、実際のメッセージはAPEXバージョンやカスタマイズにより異なる可能性がある
  - 候補：APEXテキストメッセージ設定 / アプリケーション翻訳設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Login Page実装はAPEX標準パターンに準拠しており、信頼性が高い。
- **0（低リスク）**: エラーメッセージの表示はINLINE_IN_NOTIFICATION設定（E-01 行118, 155）で確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] APEXアプリケーションの認証スキーム設定を確認し、APEX_AUTHENTICATIONが使用されているか
- [ ] persistent_cookies_enabled設定が環境で有効になっているか確認
- [ ] ログイン成功後のリダイレクト先（Home Page）がDashboard（Page 1）に設定されているか
- [ ] アプリアイコン（app-icon-512.png）がApplication Static Filesに存在するか確認
- [ ] 実際の認証失敗時のエラーメッセージ表示を動作確認
